/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   layout.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class contains layout items and is responsible for
 *              placing them on the screen, and then draw them when
 *              necessary. basically it decides to place local players
 *              in the middle of the screen and half/size network players
 *              and place them on the sides
 */

#ifndef INC_U61_LAYOUT
#define INC_U61_LAYOUT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "layoutitem.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Layout
{
 public:
  U61_Layout();
  ~U61_Layout();

  void reset();

  void init_alone(U61_Player *p);
  void init_multiplayer_1(U61_Player *p1);
  void init_multiplayer_2(U61_Player *p1,
			  U61_Player *p2);
  void init_multiplayer_3(U61_Player *p1,
			  U61_Player *p2,
			  U61_Player *p3);
  void init_multiplayer_4(U61_Player *p1,
			  U61_Player *p2,
			  U61_Player *p3,
			  U61_Player *p4);
  void init_network_1(U61_Player *p1,
                      U61_Player *net);
  void init_network_2(U61_Player *p1,
		      U61_Player *p2,
                      U61_Player *net);
                         
 
  void draw();

  static const int NB_PLAYERS_LOCAL=4;
  static const int NB_PLAYERS_NET_LOCAL=2;
  static const int NB_PLAYERS_TOTAL=10;
    
 protected:
  U61_LayoutItem items[NB_PLAYERS_TOTAL];
  CL_Canvas *background;
    
  void init_network_common(U61_Player *net);
  bool exists_changed_background();
  void prepare_background();
};

#endif
