/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   serverprotocol.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: welcomes a client, gets basic information about him
 *              and sends him all the informations about
 *              the players which are already playing
 */


#ifndef INC_U61_SERVERPROTOCOL
#define INC_U61_SERVERPROTOCOL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "protocol.h"
#include "serverdispatcher.h"
#include "game.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ServerProtocol : public U61_Protocol
{
 public:
  U61_ServerProtocol(U61_ServerDispatcher *d, int p,int ch);
  ~U61_ServerProtocol();

  virtual void check_connection();
  virtual int send_next_packet();
  virtual int recv_next_packet();

 protected:
  U61_ServerDispatcher *dispatcher;
  U61_Connection *connection[U61_Game::NB_NET_GROUPS-1]; 
  int id0[U61_Game::NB_NET_GROUPS-1];
  int id1[U61_Game::NB_NET_GROUPS-1];
  int new_connection;

  const static int LISTENING=10;
  const static int CLIENT_ACCEPTED=11;
  const static int SCRIPT_NAME_SENT=30;
  const static int SCRIPT_SENT=31;
  const static int ID0_SENT=40;
  const static int ID1_SENT=41;
  const static int INITIAL_SPEED_SENT=42;
  const static int ACCELERATION_SENT=43;
  const static int TIME_SENT=44;

  int start_listening();
  int accept_client();    
  int get_free_connection();
  int send_script_name();
  int send_script();
  int send_id0();
  int send_id1();
  int send_initial_speed();
  int send_acceleration();
  int send_time();

  void handle_error(int result);
};

#endif




