------------------------------------------------------------------------------
--                                                                          --
-- U U    6   1            U U   FFF  O   O  TTT                            --
-- U U   6   11   b        U U   F   O O O O  T                             --
-- U U - 66   1   bb  y y  U U - FF  O O O O  T                             --
-- U U   6 6  1   b b  y   U U   F   O O O O  T                             --
--  U     6   1   bb   y    U    F    O   O   T                             --
--                                                                          --
-- U61 is another block based game                                          --
-- Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   --
--                                                                          --
-- This program is free software; you can redistribute it and/or            --
-- modify it under the terms of the GNU General Public License              --
-- as published by the Free Software Foundation; either version 2           --
-- of the License, or (at your option) any later version.                   --
--                                                                          --
-- This program is distributed in the hope that it will be useful,          --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of           --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            --
-- GNU General Public License for more details.                             --
--                                                                          --
-- You should have received a copy of the GNU General Public License        --
-- along with this program; if not, write to the Free Software              --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA--
--                                                                          --
-- This project is also available on SourceForge  (http://sourceforge.net)  --
------------------------------------------------------------------------------

-- tetramino game, the goal is to have an horizontal line filled with
-- squares of any color. possible movements include translation & rotation
-- colors do not have any purpose except make the game look nicer


-- shape definition ----------------------------------------------------------

function user_new_shape(num)
    num=mod(num,7)

    return num
end

function user_do_shape(num)
    if num==0 then
        tetramino_bar()
    elseif num==1 then
        tetramino_s1()
    elseif num==2 then
        tetramino_s2()
    elseif num==3 then
        tetramino_square()
    elseif num==4 then
        tetramino_pyramid()
    elseif num==5 then
        tetramino_l1()
    elseif num==6 then
        tetramino_l2()
    end
end


-- actions -------------------------------------------------------------------

function user_rotate_left()
    rotate_block_left()    
end

function user_rotate_right()
    rotate_block_right()    
end

function user_move_left()
    goofy_translate_left()
end

function user_move_right()
    goofy_translate_right()
end

function user_move_down()
    translate_block_y(1)
end

function user_use_antedote()
    u61_cancel_curse(u61_get_oldest_curse())
end

-- pattern match -------------------------------------------------------------

function user_match_pattern(match_count)
    return match_line(match_count)
end

function user_land()

end

function user_square_blown_up(x,y)
    shift_column_down(x,y)
end

-- curse functions  ----------------------------------------------------------

function user_new_curse(num)
    num=mod(num,100)

    if num>95 then
        num=ID_CURSE_CLEAR
    elseif num>80 then
        num=ID_CURSE_GOOFY
    else 
        num=ID_CURSE_HOLED_LINE
    end

    return num
end

function user_do_curse(num,sent)
    if (num==ID_CURSE_HOLED_LINE) then
        if (sent==0) then
            u61_send_curse(num)
        else
            do_curse_holed_line()
        end
    elseif (num==ID_CURSE_GOOFY) then
        if (sent==0) then
            u61_send_curse(num)
        else
            do_curse_goofy()
        end
    elseif (num==ID_CURSE_CLEAR) then
        do_curse_clear()
    end
    
end

function user_get_curse_name(num)
    name="surprise"

    if (num==ID_CURSE_HOLED_LINE) then
        name="holedline"
    elseif (num==ID_CURSE_GOOFY) then
        name="goofy"
    elseif (num==ID_CURSE_CLEAR) then
        name="clear"
    end

    return name
end 

-- other functions -----------------------------------------------------------

function user_time_callback()
    u61_add_score(1)
end

