/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   event.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: one of the most fundamental classes of U61. An event is
 *              basically what u61 uses to control a map and send info
 *              to other computers on the network. There's a difference
 *              between U61_Event and CL_Event. CL_Event is GUI oriented
 *              for it's associated to a mouse click, a key press etc...
 *              but U61_Event is very U61 specific since it can be a
 *              drop action or a curse request.
 *              almost all events are dated.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "event.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a meaningless event
 */ 
U61_Event::U61_Event()
{
  code=0;
  author=0;
  target=0;
  par=0;
  time=0; 
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of an event
 */ 
U61_Event::~U61_Event()
{

}

/*--------------------------------------------------------------------------*/
/*
 * USefull to print an event to cout
 */
ostream &operator <<(ostream &o, U61_Event event)
{
  return o<<"code="<<event.code
	  <<"/author="<<event.author
	  <<"/target="<<event.target
	  <<"/par="<<event.par
	  <<"/time="<<event.time;
}

