------------------------------------------------------------------------------
-- This is a script file for U61 by U-Foot (www.ufoot.org ufoot@ufoot.org)  --
-- It is free software, protected by the GPL (www.fsf.org)                  --
--                                                                          --
-- Do not hesitate to modify this file to change the behavior of U61,       --
-- that's exactly what it's done for!                                       --
------------------------------------------------------------------------------


------------------------------------------------------------------------------
--                                                                          --
-- U U    6   1            U U   FFF  O   O  TTT                            --
-- U U   6   11   b        U U   F   O O O O  T                             --
-- U U - 66   1   bb  y y  U U - FF  O O O O  T                             --
-- U U   6 6  1   b b  y   U U   F   O O O O  T                             --
--  U     6   1   bb   y    U    F    O   O   T                             --
--                                                                          --
-- U61 is another block based game                                          --
-- Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   --
--                                                                          --
-- This program is free software; you can redistribute it and/or            --
-- modify it under the terms of the GNU General Public License              --
-- as published by the Free Software Foundation; either version 2           --
-- of the License, or (at your option) any later version.                   --
--                                                                          --
-- This program is distributed in the hope that it will be useful,          --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of           --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            --
-- GNU General Public License for more details.                             --
--                                                                          --
-- You should have received a copy of the GNU General Public License        --
-- along with this program; if not, write to the Free Software              --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA--
--                                                                          --
-- This project is also available on SourceForge  (http://sourceforge.net)  --
------------------------------------------------------------------------------

-- tetramino game, the goal is to have an horizontal line filled with
-- squares of any color. possible movements include translation & rotation
-- colors do not have any purpose except make the game look nicer


-- shape definition ----------------------------------------------------------

function user_new_shape(num)
    num=mod(num,7)

    return num
end

function user_do_shape(num)
    if num==0 then
        tetramino_bar()
    elseif num==1 then
        tetramino_s1()
    elseif num==2 then
        tetramino_s2()
    elseif num==3 then
        tetramino_square()
    elseif num==4 then
        tetramino_pyramid()
    elseif num==5 then
        tetramino_l1()
    elseif num==6 then
        tetramino_l2()
    end
end


-- actions -------------------------------------------------------------------

function user_rotate_left()
    rotate_block_left()    
end

function user_rotate_right()
    rotate_block_right()    
end

function user_move_left()
    goofy_translate_left()
end

function user_move_right()
    goofy_translate_right()
end

function user_move_down()
    translate_block_y(1)
end

function user_use_antedote()
    u61_cancel_curse(u61_get_oldest_curse())
end

-- pattern match -------------------------------------------------------------

function user_match_pattern(match_count)
    return match_line(match_count)
end

function user_land()

end

function user_square_blown_up(x,y)
    shift_column_down(x,y)
end

-- curse functions  ----------------------------------------------------------

function user_new_curse(num)
    num=mod(num,100)

    if num>95 then
        num=ID_CURSE_CLEAR
    elseif num>80 then
        num=ID_CURSE_GOOFY
    else 
        num=ID_CURSE_HOLED_LINE
    end

    return num
end

function user_do_curse(num,sent)
    if (num==ID_CURSE_HOLED_LINE) then
        if (sent==0) then
            u61_send_curse(num)
        else
            do_curse_holed_line()
        end
    elseif (num==ID_CURSE_GOOFY) then
        if (sent==0) then
            u61_send_curse(num)
        else
            do_curse_goofy()
        end
    elseif (num==ID_CURSE_CLEAR) then
        do_curse_clear()
    end
    
end

function user_get_curse_name(num)
    name="surprise"

    if (num==ID_CURSE_HOLED_LINE) then
        name="holedline"
    elseif (num==ID_CURSE_GOOFY) then
        name="goofy"
    elseif (num==ID_CURSE_CLEAR) then
        name="clear"
    end

    return name
end 

-- other functions -----------------------------------------------------------

function user_time_callback()
    u61_add_score(1)
end


-- various functions used for pattern matching -------------------------------

function shift_column_down(x_col,y_bottom)
    local y
    local color

    y=y_bottom
    while y>1 do
        color=u61_get_square_color(x_col,y-1)
        u61_set_square_color(x_col,y,color)
        y=y-1
    end
    u61_set_square_color(x_col,0,-1)

    if u61_get_curse_x()==x_col and u61_get_curse_y()<y_bottom then
        u61_set_curse_y(u61_get_curse_y()+1)
    end
end









-- Functions used in many curse scripts --------------------------------------

function shift_map_up()
    local x
    local y
    local width
    local height
    local color

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height-1 do
        x=0
        while x<width do
            color=u61_get_square_color(x,y+1)
            u61_set_square_color(x,y,color)
            x=x+1
        end
        y=y+1
    end

    u61_set_curse_y(u61_get_curse_y()-1)
end

function clear_map()
    local x
    local y
    local width
    local height

    width=u61_get_width()
    height=u61_get_height() 
    y=0
    while y<height do
        x=0
        while x<width do
            u61_set_square_color(x,y,-1)
            x=x+1
        end
        y=y+1
    end
end
-- defines tetraminos --------------------------------------------------------

function tetramino_bar()
    u61_add_item(0,0,0)
    u61_add_item(0,1,0)
    u61_add_item(0,2,0)
    u61_add_item(0,3,0)
end

function tetramino_s1()
    u61_add_item(0,0,1)
    u61_add_item(1,0,1)
    u61_add_item(1,1,1)
    u61_add_item(2,1,1)
end

function tetramino_s2()
    u61_add_item(0,1,2)
    u61_add_item(1,1,2)
    u61_add_item(1,0,2)
    u61_add_item(2,0,2)
end

function tetramino_square()
    u61_add_item(0,0,3)
    u61_add_item(0,1,3)
    u61_add_item(1,0,3)
    u61_add_item(1,1,3)
end

function tetramino_pyramid()
    u61_add_item(0,1,4)
    u61_add_item(1,1,4)
    u61_add_item(2,1,4)
    u61_add_item(1,0,4)
end

function tetramino_l1()
    u61_add_item(0,1,5)
    u61_add_item(1,1,5)
    u61_add_item(2,1,5)
    u61_add_item(2,0,5)
end

function tetramino_l2()
    u61_add_item(0,0,6)
    u61_add_item(0,1,6)
    u61_add_item(1,1,6)
    u61_add_item(2,1,6)
end


-- defines translations ------------------------------------------------------

function translate_block_x(x)
    u61_set_block_x(u61_get_block_x()+x)
end

function translate_block_y(y)
    u61_set_block_y(u61_get_block_y()+y)
end


-- defines geometrical rotations ---------------------------------------------

function rotate_block_left()
    local x
    local y
    local i 

    i = u61_get_nb_items()-1
    while i>=0 do
        x = u61_get_item_x(i) 
        y = u61_get_item_y(i) 
        x,y = y,-x
        u61_set_item_x(i,x)
        u61_set_item_y(i,y)
        i = i-1
    end
end

function rotate_block_right()
    local x
    local y
    local i 

    i = u61_get_nb_items()-1
    while i>=0 do
        x = u61_get_item_x(i) 
        y = u61_get_item_y(i) 
        x,y = -y,x
        u61_set_item_x(i,x)
        u61_set_item_y(i,y)
        i = i-1
    end
end

-- line pattern: any complete line of square is removed ----------------------

function delete_line(y_line)
    local x
    local y
    local width
    local color

    width=u61_get_width()
    x=0
    while x<width do
        u61_blow_up_square(x,y_line)
        x=x+1
    end
end

function match_line(match_count)
    local x
    local y
    local width
    local height
    local holes
    local lines
    
    width=u61_get_width()
    height=u61_get_height()

    lines=0
    y=0
    while y<height and lines==0 do
        holes=0
        x=0
        while x<width do
            if u61_get_square_color(x,y)<0 then
                holes=holes+1
            end
            if not (u61_is_square_exploding(x,y)==0) then
                holes=holes+1
            end
            x=x+1
        end
        if holes==0 then 
            delete_line(y)
            lines=lines+1
        end
        y=y+1
    end    

    if lines>0 then
        u61_add_score((match_count+1)*1000)    
        if (match_count>=3) then
            u61_add_antedote()
        end
    end

    return lines
end


-- ADD_LINE curse: adds a line with a hole in it -----------------------------

ID_CURSE_HOLED_LINE=0

function do_curse_holed_line()
    local x
    local y
    local width
    local height
    local color

    shift_map_up()

    width=u61_get_width()
    height=u61_get_height() 

    x=0
    while x<width do
        if (mod(x+u61_get_time(),width)==0) then
            color=-1
        else
            color=7
        end
        u61_set_square_color(x,height-1,color)
        x=x+1
    end
end


-- CLEAR curse: clears the whole map -----------------------------------------

ID_CURSE_CLEAR=1

function do_curse_clear()
    clear_map()
end


-- GOOFY curse: inverts the right & left keys --------------------------------

ID_CURSE_GOOFY=2

function do_curse_goofy()
    u61_register_curse(ID_CURSE_GOOFY,120)
end

function goofy_translate_left()
    if (u61_get_curse_age(ID_CURSE_GOOFY)<0) then
        translate_block_x(-1)
    else
        translate_block_x(1)
    end    
end

function goofy_translate_right()
    if (u61_get_curse_age(ID_CURSE_GOOFY)<0) then
        translate_block_x(1)
    else
        translate_block_x(-1)
    end    
end

