/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   application.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: main file, where the ClanLib application object is defined
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "application.h"
#include "global.h" 
#include "version.h" 

#include <stdio.h> 

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

U61_Application application;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * title of the application window
 */ 
char *U61_Application::get_title()
{
  char buf[U61_STRING_SIZE];        
    
  U61_Version::get_version_text(buf);
  sprintf(app_name,
	  "U61 %s by U-Foot (ufoot@ufoot.org / www.ufoot.org)",
	  buf);

  return app_name; 
}

/*--------------------------------------------------------------------------*/
/*
 * main function of the application
 */
int U61_Application::main(int argc, char **argv)
{
  CL_SetupCore::init();
  CL_SetupCore::init_display();
  CL_SetupCore::init_sound();
  CL_SetupCore::init_network();

  if (U61_Global::game.init(argv[0]))
    {
      U61_Global::game.run();
    }
  U61_Global::game.deinit();

  return 0;

  CL_SetupCore::deinit_network();    
  CL_SetupCore::deinit_sound();
  CL_SetupCore::deinit_display();
  CL_SetupCore::deinit();
}

