/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   keymenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is associated to a specific player
 *              it allows the player to change his key settings
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "keymenu.h"
#include "keychoose.h"
#include "global.h"
#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_KeyMenu::U61_KeyMenu(U61_Menu *parent,
                         U61_PlayerConfig *conf) 
    : U61_Menu(parent,"Choose your key settings")
{
    config=conf;

    add_item(new U61_KeyChoose("Start/Stop",
                               &(config->key_start_stop)));
    add_item(new U61_KeyChoose("Move left",
                               &(config->key_move_left)));
    add_item(new U61_KeyChoose("Move right",
                               &(config->key_move_right)));
    add_item(new U61_KeyChoose("Rotate left",
                               &(config->key_rotate_left)));
    add_item(new U61_KeyChoose("Rotate right",
                               &(config->key_rotate_right)));
    add_item(new U61_KeyChoose("Move down",
                               &(config->key_move_down)));
    add_item(new U61_KeyChoose("Drop",
                               &(config->key_drop)));
    add_item(new U61_KeyChoose("Next victim",
                               &(config->key_next_victim)));
    add_item(new U61_KeyChoose("Previous victim",
                               &(config->key_prev_victim)));
    add_item(new U61_KeyChoose("Use antedote",
                               &(config->key_use_antedote)));

    select(0);
}

