/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   layoutitem.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a layout item is a map plus the informations to draw it
 *              this includes its position, its size etc...
 *              layout items are initialized and parametered 
 *              in the layout class
 */


#ifndef INC_U61_LAYOUTITEM
#define INC_U61_LAYOUTITEM

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "player.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_LayoutItem
{
public:
    U61_LayoutItem();
    ~U61_LayoutItem();
    
    void reset();
    void init(U61_Player *p,int x,int y,int s);
    int get_player_id();
    bool is_player_available();

    bool has_background_changed();
    void draw_background(CL_Canvas *target);

    void draw();

protected:
    bool active;
    U61_Player *player;
    bool bg_changed;

    int size;
    int x_center;
    int y_center;
    int x_map;
    int y_map;
    int x_info;
    int y_info;

    void calc_coords();
};

#endif
