/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   player.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a player is a bundle of
 *              - an event source
 *              - an event copy
 *              - a "sure" map
 *              - a "last" map
 *              - a API to handle all that...
 *              it's fundamental to understand the difference between the
 *              last map and the sure map. 
 *              the sure map is a map freezed at the time of the latest
 *              event received. since events are ordered by time, we can
 *              assume this is the right map at this givent instant
 *              the last map is an anticipated map. from the suremap state,
 *              it simulates game cycles so that the map is "as it would have
 *              been now (which may be later than the latest event) if no
 *              event occured". This way, in a network game, map never freeze
 *              waiting for network events, and this gives an impression of
 *              speed even with poor bandwidth
 */


#ifndef INC_U61_PLAYER
#define INC_U61_PLAYER

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "data.h"
#include "playerconfig.h"
#include "const.h"
#include "map.h"
#include "eventsource.h"
#include "eventcopy.h"
#include "input.h"
#include "dispatcher.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Player
{ 
 public:
  U61_Player();
  ~U61_Player();  

  void reset();

  void set_id(int player_id);
  int get_id();

  char *get_name();
  int get_target_id();
  int get_score();
  int get_best_score();
  U61_Block get_next_block();
  int get_nb_curse();
  int get_nb_antedote();
  char *get_curse_name();

  void init_local(U61_Input *input,
                  U61_Dispatcher *d,
		  int id,
		  int time,
		  U61_PlayerConfig *conf,
		  bool start=true);
  void init_network(U61_Dispatcher *d,
		    int id);

  bool is_available();
  bool is_active();
  bool is_local();

  void pump_events();

  void draw(int x,int y,int size=U61_Data::SIZE_BIG);

  void kill();
 protected:
  int id;

  bool available;
  bool local;

  U61_EventSource *source;
  U61_EventCopy *copy;

  U61_Map last;
  U61_Map sure;

  bool *prevision;

  void handle_event(U61_Event *evt);
  void start(int time);
  void stop();

  void copy_sure_to_last();
};

#endif
