/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   number.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu item allows the user to enter a number
 *              the value may be changed using the arrow keys 
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>
#include <stdio.h>

#include "const.h"
#include "number.h"
#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'toggable' item
 */ 
U61_Number::U61_Number(char *label, int *val,
                       int min_val, int max_val) : U61_MenuItem()
{
    name=label;
    value=val;
    min_value=min_val;
    max_value=max_val;
    check_range();
    update();
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text displayed so that it reflects the value of the item
 */
void U61_Number::update()
{
    char buffer1[U61_STRING_SIZE];
    char buffer2[U61_STRING_SIZE];

    /*
     * puts the number into a string
     */
    sprintf(buffer2,"%d",*value);

    /*
     * we want the text in the item to look like "blablabla is on"
     */
    strcpy(buffer1,name);
    strcat(buffer1,SEPARATOR);
    strcat(buffer1,buffer2);

    /*
     * puts the prepared string in the label
     */
    set_text(buffer1);
}

/*--------------------------------------------------------------------------*/
/*
 * increments the value
 */
void U61_Number::inc()
{
    (*value)++;
    check_range();
}

/*--------------------------------------------------------------------------*/
/*
 * decrements the value
 */
void U61_Number::dec()
{
    (*value)--;
    check_range();
}

/*--------------------------------------------------------------------------*/
/*
 * checks if the value is not too large or small
 */
void U61_Number::check_range()
{
    if ((*value)<min_value)
    {
        (*value)=max_value;
    }
    if ((*value)>max_value)
    {
        (*value)=min_value;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_Number::action(int key)
{
    bool changed=false;

    switch (key)
    {
    case CL_KEY_ENTER:
    case CL_KEY_RIGHT:
        changed=true;
        inc();
        break;
    case CL_KEY_LEFT:
        changed=true;
        dec();
        break;
    }
    
    return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * selection of the item (only selects the number value)
 */
void U61_Number::select()
{
    int start;

    start=strlen(name);
    
    select_right(start); 
}
