/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   sound.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: all sound playing (except music) are done through this
 *              class. just ask for a "game start" sound and it's there
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "sound.h"
#include "global.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * contains the name of the log file
 */
bool U61_Sound::state=true;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * plays a sound if sound is enabled!
 */
void U61_Sound::play(CL_SoundBuffer *sound)
{
    if (state && sound!=NULL)
    {
        sound->play();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the game starts
 */
void U61_Sound::play_game_start()
{
    play(U61_Global::data.sound_game_start);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the users navigates into menu items
 */
void U61_Sound::play_menu_move()
{
    play(U61_Global::data.sound_menu_move);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the user changes its current menu
 */
void U61_Sound::play_menu_validate()
{
    play(U61_Global::data.sound_menu_validate);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a block touches the ground
 */
void U61_Sound::play_block_touch()
{
    play(U61_Global::data.sound_block_touch);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when the player completes a pattern
 */
void U61_Sound::play_block_pattern()
{
    play(U61_Global::data.sound_block_pattern);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a player enters the game
 */
void U61_Sound::play_player_start()
{
    play(U61_Global::data.sound_player_start);
}

/*--------------------------------------------------------------------------*/
/*
 * this sound is played when a player receives a curse
 */
void U61_Sound::play_curse_receive()
{
    play(U61_Global::data.sound_curse_receive);
}

