/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   letter.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the letter class allows the drawing of funny dancing letters
 *              it contains information about the letter offset and provides
 *              functions to draw it
 */


#ifndef INC_U61_LETTER
#define INC_U61_LETTER

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Letter
{
public:
    U61_Letter(CL_Font *fnt,char code=' ');
    ~U61_Letter();
    
    char operator =(char code);
    void set_font(CL_Font *fnt);
    int get_ascii();
    void draw(int x,int y);
    int get_height();
    int get_width();
    void enable_dance();
    void disable_dance();
    void enable_blink();
    void disable_blink();
protected:
    char ascii;
    CL_Font *font;
    int last_time;
    bool dance_state;
    bool blink_state;
 
    int dx;
    int dy;
    int vx;
    int vy;
 
    static const int W_MAX_MOVE=2;
    static const int H_MAX_MOVE=3;

    static const int SLOW_FACTOR=5;
 
    void compute();
    void change_vx();
    void change_vy();
    void change_dx();
    void change_dy();
};

#endif
