/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   playermenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this menu is associated to a specific player
 *              and allows the viewing/changing of its settingd
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "playermenu.h"
#include "keymenu.h"
#include "advancedkeymenu.h"
#include "emptymenu.h"
#include "toggle.h"
#include "edit.h"
#include "button.h"
#include "global.h"
#include "menuinput.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the option menu
 */ 
U61_PlayerMenu::U61_PlayerMenu(U61_Menu *parent,
                               U61_PlayerConfig *conf)
    : U61_Menu(parent,"Player settings")
{
    config=conf;
    add_item(new U61_Edit("Name",config->name));
    add_item(new U61_Button("Key settings"));
    add_item(new U61_Button("Advanced key settings"));
    add_item(new U61_Toggle("Anticipation mode is",&(config->anticipation),
                            "on","off"));
    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_PlayerMenu::validate()
{
    U61_Menu *next_menu;

    next_menu=this;
    switch (selection)
    {
    case 1:
        next_menu=new U61_KeyMenu(this,config);
        break;
    case 2:
        next_menu=new U61_AdvancedKeyMenu(this,config);
        break;
    }

    return next_menu;
}
