/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   music.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to start and stop playing music, one just has to ask
 *              for music number 'n' to be played and it starts playing
 *              and does automatically internal checks such as "does this
 *              music index exists in my current datafile"
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "music.h"
#include "global.h"
#include "debug.h"
#include "utils.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * handler on the music being played, NULL if no music selected
 */    
CL_SoundBuffer_Session *U61_Music::session=NULL;

/*--------------------------------------------------------------------------*/
/*
 * Counter used to know when the current music must be changed
 */    
int U61_Music::change_counter=0;

/*--------------------------------------------------------------------------*/
/*
 * Index of the last chosen music
 */    
int U61_Music::last_chosen=-1;

/*--------------------------------------------------------------------------*/
/*
 * Number of times to call change() before the music actually changes
 */    
int U61_Music::change_limit=1;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Starts playing a new music (called when one starts a new game)
 */
void U61_Music::start()
{
  int volume;

  if (session==NULL)
    {
      change(true);
    }

  if (session!=NULL)
    {
      volume=U61_Global::config.sound_volume;
   
      if (volume>0)
	{
	  session->set_volume(2.0*((float) volume)
			      /((float) U61_MUSIC_VOLUME_MAX));
	  session->set_position(0);
	  if (!session->is_playing())
	    {
	      session->play();
	    }
	}
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Stops playing the music (called when one exists a game)
 */
void U61_Music::stop()
{
  if (session!=NULL)
    {
      session->stop();
      delete session;
      session=NULL;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * This callback must be called regularly 
 */
void U61_Music::update()
{
  int volume;

  volume=U61_Global::config.music_volume;
  if (session!=NULL)
    {
      if (volume>0)
	{
	  if (!session->is_playing())
	    {
	      start();
	    }

	  if (session!=NULL)
	    {	  
	      session->set_volume(2.0*((float) volume)
				  /((float) U61_MUSIC_VOLUME_MAX));
	    }
	}
      else
	{
	  session->stop();
	}
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Pauses the music, for instance when one is moving throw the menus
 */
void U61_Music::pause()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Resumes the music.
 */
void U61_Music::resume()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Sets the "change limit". In fact, change only calls changes the current
 * music if it has been called a minimum number of times. This avoids the
 * music to change all the time in a local multiplayer game.
 */
void U61_Music::set_change_limit(int limit)
{
  change_limit=limit;
}

/*--------------------------------------------------------------------------*/
/*
 * Changes the current music.
 */
void U61_Music::change(bool force)
{
  int chosen=0;

  if (force)
    {
      change_counter=change_limit;
    }

  change_counter++;
  if (change_counter>=change_limit)
    {
      change_counter=0;
      if (U61_Global::data.nb_music>0)
	{
	  chosen=U61_Utils::random(U61_Global::data.nb_music);
	  /*
	   * Now this is a little trick so than when there are at least
	   * 2 different musics, we are sure the music changes for good
	   */
	  if (U61_Global::data.nb_music>1)
	    {
	      while (chosen==last_chosen)
		{
		  chosen=U61_Utils::random(U61_Global::data.nb_music);
		}
	    }

	  last_chosen=chosen;

	  stop();

	  session=new CL_SoundBuffer_Session
	    (U61_Global::data.music[chosen]->prepare());
	}
    }
}

