/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   scoreline.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class represents all the score parameters for a given
 *              player. So basically the score class is a hash of scoreline
 *              items, which hold the real numbers.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "scoreline.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_SCORELINE_TOTAL_SCORE_LIMIT 1000000000

/*---------------------------------------------------------------------------
 methods
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Constructor of the score class
 */
U61_ScoreLine::U61_ScoreLine()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * Destructor of the score class
 */
U61_ScoreLine::~U61_ScoreLine()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Resets all the items of a score
 */
void U61_ScoreLine::reset()
{
  strcpy(name,"");
  nb_games=0;
  max_score=0;
  total_score=0;
  max_time=0;
  total_time=0;
  total_curse_sent=0;
  total_curse_received=0;
}

/*--------------------------------------------------------------------------*/
/*
 * Acknowledges the results of a game.
 */
void U61_ScoreLine::register_game(int score,
				  unsigned int time,
				  int curse_sent,
				  int curse_received)
{
  nb_games++;
  if (score>max_score)
    {
      max_score=score;
    }
  if (time>max_time)
    {
      max_time=time;
    }
  total_score+=score;
  if (total_score>=U61_SCORELINE_TOTAL_SCORE_LIMIT)
    {
      total_score=U61_SCORELINE_TOTAL_SCORE_LIMIT-1;
    }
  total_time+=time;
  total_curse_sent+=curse_sent;
  total_curse_received+=curse_received;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the name of the player
 */
char *U61_ScoreLine::get_name()
{
  return name;
}

/*--------------------------------------------------------------------------*/
/*
 * Sets the name of the player
 */
void U61_ScoreLine::set_name(char *n)
{
  strcpy(name,n);
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the number of games played
 */
int U61_ScoreLine::get_nb_games()
{
  return nb_games;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the sum of all the scores obtained by this player
 */
int U61_ScoreLine::get_total_score()
{
  return total_score;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the maximum score reached for this player
 */
int U61_ScoreLine::get_max_score()
{
  return max_score;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the average score reached by this player
 */
int U61_ScoreLine::get_avg_score()
{
  if (nb_games>0)
    return total_score/nb_games;
  else
    return 0;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the sum of all the time played by this player
 */
unsigned int U61_ScoreLine::get_total_time()
{
  return total_time;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the maximum time reached by this player
 */
unsigned int U61_ScoreLine::get_max_time()
{
  return max_time;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the average time of this player
 */
unsigned int U61_ScoreLine::get_avg_time()
{
  if (nb_games>0)
    return total_time/nb_games;
  else
    return 0;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the average number of curses sent by the player
 */
int U61_ScoreLine::get_avg_curse_sent()
{
  if (nb_games>0)
    return total_curse_sent/nb_games;
  else
    return 0;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the average number of curses received by the player
 */
int U61_ScoreLine::get_avg_curse_received()
{
  if (nb_games>0)
    return total_curse_received/nb_games;
  else
    return 0;
}



