/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   blockitem.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a block item is a square associated to an x,y couple
 *              this allows the block class to be a collection of blockitems
 *              instead of a collection of squares with a dirty array
 *              holding the coordinates of these squares
 */

#ifndef INC_U61_BLOCKITEM
#define INC_U61_BLOCKITEM

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "square.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_BLOCKITEM_COORD_MAX 10

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_BlockItem
{
public:
    U61_BlockItem();
    ~U61_BlockItem();
    
    U61_Square square;    

    void set_x(int val);
    void set_y(int val);
    int get_x();
    int get_y();

    void reset();

protected:
    int x;
    int y;

};

#endif
