/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   data.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the data object holds all the data of the game
 *              this includes the graphics, the sounds and anything
 *              which is included in the datafile
 *              it provides an easy and standard way for all other
 *              classes to access the game resources
 */

#ifndef INC_U61_DATA
#define INC_U61_DATA

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/sound.h>
#include <ClanLib/display.h>

#include "const.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_DATA_NB_SQUARE_TYPE 8
#define U61_DATA_NB_SIZE 2
#define U61_DATA_SIZE_BIG 0
#define U61_DATA_SIZE_SMALL 1
#define U61_DATA_NB_MAP_MAX 128
#define U61_DATA_NB_MUSIC_MAX 1024

#define U61_DATA_SYMBOL_CURSE_BAD "-"
#define U61_DATA_SYMBOL_CURSE_GOOD "+"
#define U61_DATA_SYMBOL_ANTIDOTE "a"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Data
{
 public:
  U61_Data();
  ~U61_Data();

  bool load1(char *name);
  bool load2();
  void unload();
  
  void chdir_to_data_dir();
  void chdir_to_initial_dir();

  int screen_w;
  int screen_h;

  int square_w[U61_DATA_NB_SIZE];
  int square_h[U61_DATA_NB_SIZE];
  int map_w[U61_DATA_NB_SIZE];
  int map_h[U61_DATA_NB_SIZE];
  int info_w[U61_DATA_NB_SIZE];
  int info_h[U61_DATA_NB_SIZE];
  int player_w[U61_DATA_NB_SIZE];
  int player_h[U61_DATA_NB_SIZE];

  int offset_map_x[U61_DATA_NB_SIZE];
  int offset_map_y[U61_DATA_NB_SIZE];
  int offset_info_x[U61_DATA_NB_SIZE];
  int offset_info_y[U61_DATA_NB_SIZE];
  int offset_squares_x[U61_DATA_NB_SIZE];
  int offset_squares_y[U61_DATA_NB_SIZE];
  int offset_name_x[U61_DATA_NB_SIZE];
  int offset_name_y[U61_DATA_NB_SIZE];
  int offset_score_x[U61_DATA_NB_SIZE];
  int offset_score_y[U61_DATA_NB_SIZE];
  int offset_target_x[U61_DATA_NB_SIZE];
  int offset_target_y[U61_DATA_NB_SIZE];
  int offset_preview_x[U61_DATA_NB_SIZE];
  int offset_preview_y[U61_DATA_NB_SIZE];
  int offset_curses_x[U61_DATA_NB_SIZE];
  int offset_curses_y[U61_DATA_NB_SIZE];
  int offset_antidotes_x[U61_DATA_NB_SIZE];
  int offset_antidotes_y[U61_DATA_NB_SIZE];
  int offset_next_curse_x[U61_DATA_NB_SIZE];
  int offset_next_curse_y[U61_DATA_NB_SIZE];
   
  int nb_map;
  int nb_music;

  CL_Font *font_menu;
  CL_Font *font_info[U61_DATA_NB_SIZE];
  CL_Font *font_symbol[U61_DATA_NB_SIZE];
 
  CL_SoundBuffer *sound_game_start;
  CL_SoundBuffer *sound_menu_move;
  CL_SoundBuffer *sound_menu_validate;
  CL_SoundBuffer *sound_block_touch;
  CL_SoundBuffer *sound_block_pattern;
  CL_SoundBuffer *sound_player_start;
  CL_SoundBuffer *sound_curse_receive;
  CL_SoundBuffer *sound_player_loose;
 
  CL_SoundBuffer *music[U61_DATA_NB_MUSIC_MAX];
 
  CL_Surface *square[U61_DATA_NB_SQUARE_TYPE][U61_DATA_NB_SIZE];
  CL_Surface *curse[U61_DATA_NB_SIZE];
  CL_Surface *anticipation[U61_DATA_NB_SIZE];
  CL_Surface *explosion[U61_DATA_NB_SIZE];

  CL_Surface *map[U61_DATA_NB_MAP_MAX][U61_DATA_NB_SIZE];

  CL_Surface *back;
  CL_Surface *shade;

  CL_Surface *info[U61_DATA_NB_SIZE];

 protected:
  CL_ResourceManager *manager;
  bool packed_data;
  char initial_dir[U61_CONST_STRING_SIZE+1];
  char data_dir[U61_CONST_STRING_SIZE+1];

  bool load_properties();
  bool load_fonts();
  bool load_sounds();
  bool load_musics();
  bool load_squares();
  bool load_maps();
  bool load_back();
  bool load_info();
};

#endif
