/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   game.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: basically contains the main game loop, the object
 *              game is created by the application object, and then
 *              controls everything. I tried to keep this file as small
 *              as possible but it's not so easy...
 *              however, if you want to see how the game works, this
 *              is *the* file to check. 
 *              it loads, the config, starts the gfx mode, loads data
 *              then launches the menu etc...
 */

#ifndef INC_U61_GAME
#define INC_U61_GAME

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h> 

#include "layout.h"
#include "menu.h"
#include "input.h"
#include "menuinput.h"
#include "playerinput.h"
#include "config.h"
#include "data.h"
#include "player.h"
#include "protocol.h"
#include "dispatcher.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_GAME_NB_NET_GROUPS 5

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Game
{ 
 public:

  U61_Game();
  ~U61_Game();
  bool init(char *filename);
  void deinit();
  void run();
  void quit();
  void restart();

  void configure_cold();
  void configure_hot();
  void start_quick();
  void start_local_alone();
  void start_local_multiplayer();
  void start_network_new();
  void start_network_join();
  void do_network_join(char *script,
		       int id0,int id1,
		       int speed,int accel,int delay,
		       int time);
  void stop();

  int get_local_player(int order);
  int find_free_player_id0();
  int find_free_player_id1();
  U61_Player *find_player_by_id(int id);

  int initial_speed;
  int acceleration;
  int curse_delay;

  U61_Menu *get_current_menu();
  void force_menu(U61_Menu *m);
  
 protected:
  char exe_name[U61_CONST_STRING_SIZE];
  U61_MenuInput menu_input;
  U61_PlayerInput player_input[U61_LAYOUT_NB_PLAYERS_LOCAL]; 
  U61_Player player[U61_LAYOUT_NB_PLAYERS_TOTAL];
  U61_Protocol *protocol;
  U61_Dispatcher *dispatcher;

  bool standard_init();
  void stop_network();

  void bind_keys();
  void reset_players();
  void pump_player_events();

  void time_reset(int time=1);

  void poll();
  void display();
  void menu();
  void logic();
  void network();

  int find_free_player_id(int start, int step);
  int find_free_network_slot();
  bool exists_player_id(int player_id);

  U61_Menu *current_menu;

  int state;
  bool slow_down_allowed;

  int last_clanlib_time_polled;
  int last_u61_time_polled;
  int last_menu_time_polled;
    
  int calls_to_poll;
  int calls_to_poll_clanlib;
  int calls_to_poll_u61;
  int calls_to_poll_menu;

  int calls_to_display;
  int calls_to_menu;
  int calls_to_logic;
};

#endif
