/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   map.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: I called this class map for I can't imagine a game without
 *              a "map" class 8) . seriously, a map is where the information
 *              about where the blocks are is stored. it's basically an array
 *              of squares.
 *              it also provides an API to move the player's falling block
 *              and handle any event.
 *              it's important to note that most of the behaviors of a map
 *              are determined by embedded LUA scripts
 */

#ifndef INC_U61_MAP
#define INC_U61_MAP

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "square.h"
#include "block.h"
#include "event.h"
#include "data.h"
#include "registeredcurse.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_MAP_WIDTH 10
#define U61_MAP_HEIGHT 25
#define U61_MAP_NAME_SIZE 8
#define U61_MAP_NB_GLOBAL 1000
#define U61_MAP_MAX_CURSE_ID 1000
#define U61_MAP_MAX_USER_SPEED 20
#define U61_MAP_MAX_USER_ACCEL 10

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Map
{ 
public:
    U61_Map();
    ~U61_Map();  

    void init(int id,int s,int a,int d);
    void reset();
    void clear();
    void begin();
    void handle_event(U61_Event *event);
    void anticipate(int time);

    void poll_auto_events();
    U61_Event get_auto_event();
    bool exists_auto_event();

    U61_Event get_request_event();
    bool exists_request_event();

    void change_background();
    int get_background();
    void set_square_color(int x,int y,int color);
    int get_square_color(int x,int y);

    void set_score(int s);
    int get_score();
    void add_score(int s);
    int get_elapsed_time();
    int get_curse_sent();
    int get_curse_received();
    int get_time();
    int get_match_count();
    void set_global(int i,int glob);
    int get_global(int i);

    int get_curse_age(int i);
    void register_curse(int i,int length,bool good);
    void cancel_curse(int i);
    int get_oldest_curse(bool good);
    int get_nb_curse(bool good);
    int get_nb_antidote();
    void add_antidote();
    void delete_antidote();

    int get_curse_x();
    int get_curse_y();
    bool get_curse_state();
    void set_curse_x(int x);
    void set_curse_y(int x);
    void set_curse_state(bool state);
    bool is_curse_available();
    void send_curse(int par);
    char *get_curse_name();

    bool is_block_ok(U61_Block *test);

    int get_target_id();

    void draw(int x,int y, 
              int size=U61_DATA_SIZE_BIG,
              bool anti=false);

    void mute();

    bool is_active();
    void set_active(int time);
    void set_inactive();

    void set_anticipation_state(bool state);
    bool get_anticipation_state();

    void set_preview_state(bool state);
    bool get_preview_state();

    void set_speed(int s);
    int get_speed();

    void set_accel(int a);
    int get_accel();

    char *get_name();

    void blow_up_square(int x, int y);
    bool is_square_exploding(int x,int y);
    bool exists_explosion();

    U61_Block get_next_block();

protected:
    U61_Square squares[U61_MAP_WIDTH][U61_MAP_HEIGHT];
    U61_Block block;
    U61_Block next_block;
    U61_Block block_anticipation;
    std::list<U61_Event> auto_events;
    std::list<U61_Event> request_events;
    int global_val[U61_MAP_NB_GLOBAL];
    U61_RegisteredCurse registered_curse[U61_MAP_MAX_CURSE_ID];
    char name[U61_MAP_NAME_SIZE+1];

    int player_id;
    int target_id;
    int background;
    bool active;
    bool silent;
    int map_time;
    bool block_requested;
    bool matching;
    int curse_delay;
    int speed_counter;
    int accel_counter;
    int speed;
    int accel;
    int base_speed;
    int base_accel;
    int score;
    int curse_sent;
    int curse_received;
    int start_time;
    int match_count;
    bool anticipation_state;
    bool preview_state;
    int curse_x;
    int curse_y;
    bool curse_state;
    bool curse_chosen;
    bool curse_asked;
    int curse_id;
    int curse_counter;
    int nb_antidote;

    void compute_next();
    void update_speed();
    void compute_up_to(int time);
    void put_auto_event(U61_Event event);
    void put_request_event(U61_Event event);

    void draw_anticipation(int x,int y, int size=U61_DATA_SIZE_BIG);

    void block_rotate_left();
    void block_rotate_right();
    void block_move_left();
    void block_move_right();
    void block_move_down();
    void block_drop();
    void prev_victim(U61_Event *event);
    void next_victim(U61_Event *event);
    void set_victim(int id);
    void name_add_letter(char c);
    void use_antidote();

    bool is_block_active();
  
    void new_block(int shape);
    void stabilize_block();
    void loose();

    void match_pattern();
    void time_callback_1();
    void time_callback_10();
    void time_callback_100();

    void check_speed();
    void check_accel();

    void update_explosions();

    void new_curse(int id);
    void request_curse(U61_Event event);
    void do_curse(U61_Event event);

    void check_curse();
    void check_target();
    void check_block();
};

#endif



