/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   platform.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains platform-specific code.
 *              there's no platform.cpp file, instead one could find
 *              platformunix.cpp for instance. 
 *              one of the main differences is the file structure
 */


#ifndef INC_U61_PLATFORM
#define INC_U61_PLATFORM

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Platform
{
  static char *get_user_path();
  static char *get_data_path();

 public:
  static char *getcwd();
  static void chdir(char *dir);
  static void keep_dir_only(char *path);

  static char *get_builtin_theme_path();
  static char *get_builtin_script_path();
  static char *get_user_theme_path();
  static char *get_user_script_path();
  static char *get_config_file();

  static void strip_remote_script_path(char *path);
  static void unstrip_remote_script_path(char *path);
    
  static bool open_dir(char *dir,char *ext="");
  static char *next_file();
  static bool close_dir();

  static bool create_user_dir(); 

  static void exec(char *file);

  static void open_score_file();
  static void close_score_file();
  static void dump_score(char *text);

  static void open_log_files();
  static void close_log_files();
  static void log_to_error_file(char *text);
  static void log_to_warning_file(char *text);
  static void log_to_message_file(char *text);
  static void log_to_debug_file(char *text,char *file,int line);
 protected:
    
};

#endif
