/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   protocol.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: contains the network code which is needed to initialize the
 *              maps on the client. this can be quite a complex process
 *              since we can not interrupt the game when someone logs in.
 *              and the amount of data to transmit might be high 
 *              (especially if the lua scripts are big)
 *              So we use lots of small messages and this forms what
 *              I call the "login protocol" and is maybe the most complex
 *              thing in U61...
 */


#ifndef INC_U61_PROTOCOL
#define INC_U61_PROTOCOL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/network.h>

#include "connection.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_PROTOCOL_GAME_ID        "U61 by U-Foot"

#define U61_PROTOCOL_DONE 0
#define U61_PROTOCOL_LATER 1
#define U61_PROTOCOL_FAILED 2

#define U61_PROTOCOL_BEGIN 0
#define U61_PROTOCOL_END -1

#define U61_PROTOCOL_ID_SENT 20
#define U61_PROTOCOL_ID_RECEIVED 21
#define U61_PROTOCOL_VERSION_SENT 22
#define U61_PROTOCOL_VERSION_RECEIVED 23
#define U61_PROTOCOL_READY_SENT 50
#define U61_PROTOCOL_READY_RECEIVED 51
#define U61_PROTOCOL_TIMEOUT 10

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Protocol
{
 public:
  U61_Protocol(int p,int c);
  virtual ~U61_Protocol();

  virtual void check_connection();
  virtual int send_next_packet();
  virtual int recv_next_packet();
  void reset();
  int get_stage();
  bool done();
  int send_all();
  int recv_all();
  void print_diagnostic();

 protected:
  int stage;
  int step;
  int port;
  int channel;
  std::string diagnostic;

  CL_NetSession *session;

  int send_id(U61_Connection *conn);
  int recv_id(U61_Connection *conn);
  int send_version(U61_Connection *conn);
  int recv_version(U61_Connection *conn);
  int send_ready(U61_Connection *conn);
  int recv_ready(U61_Connection *conn);
};

#endif


