/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   scoreline.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: this class represents all the score parameters for a given
 *              player. So basically the score class is a hash of scoreline
 *              items, which hold the real numbers.
 */

#ifndef INC_U61_SCORELINE
#define INC_U61_SCORELINE

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "const.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ScoreLine
{
 public:
  U61_ScoreLine();
  ~U61_ScoreLine();

  void reset();
  void set_name(char *name);
  char *get_name();
  void register_game(int score,
		     unsigned int time,
		     int curse_sent,
		     int curse_received);
  int get_nb_games();
  int get_total_score();
  int get_max_score();
  int get_avg_score();
  unsigned int get_total_time();
  unsigned int get_max_time();
  unsigned int get_avg_time();
  int get_avg_curse_sent();
  int get_avg_curse_received();

 protected:
  char name[U61_CONST_STRING_SIZE];
  int nb_games;
  int max_score;
  int total_score;
  unsigned int max_time;
  unsigned int total_time;
  int total_curse_sent;
  int total_curse_received;
};

#endif
