/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   clientprotocol.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the client sends informations about him and retrieves
 *              information from the server, including the rules and
 *              the state of all the other players
 */


#ifndef INC_U61_CLIENTPROTOCOL
#define INC_U61_CLIENTPROTOCOL

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "protocol.h"
#include "clientdispatcher.h"
#include "const.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_CLIENTPROTOCOL_JOIN_DELAY              100

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ClientProtocol : public U61_Protocol
{
 public:
  U61_ClientProtocol(U61_ClientDispatcher *d, 
		     int p, int ch, 
		     char *id, bool bcast);
  ~U61_ClientProtocol();

  virtual void check_connection();
  virtual int send_next_packet();
  virtual int recv_next_packet();

 protected:
  
  char *server_id;
  bool broadcast;
  U61_ClientDispatcher *dispatcher;
  U61_Connection *connection;
  int id0;
  int id1;
  int initial_speed;
  int acceleration;
  int curse_delay;
  int time;
  unsigned int join_delay_start;
  int channel_to_test;

  int start_searching();
  int connect_to_server();
  int join_delay();
  int find_channel();
  int recv_script_name();
  int recv_script();
  int recv_id0();
  int recv_id1();
  int recv_initial_speed();
  int recv_acceleration();
  int recv_curse_delay();
  int recv_time();

  void start_game();
};

#endif
