/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   event.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: one of the most fundamental classes of U61. An event is
 *              basically what u61 uses to control a map and send info
 *              to other computers on the network. There's a difference
 *              between U61_Event and CL_Event. CL_Event is GUI oriented
 *              for it's associated to a mouse click, a key press etc...
 *              but U61_Event is very U61 specific since it can be a
 *              drop action or a curse request.
 *              almost all events are dated.
 */

#ifndef INC_U61_EVENT
#define INC_U61_EVENT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <iostream.h>

#define U61_EVENT_NOTHING            0

#define U61_EVENT_START_STOP         1
#define U61_EVENT_KILL               2

#define U61_EVENT_NAME_LETTER        3
#define U61_EVENT_CHANGE_BACKGROUND  4

#define U61_EVENT_MOVE_LEFT          5
#define U61_EVENT_MOVE_RIGHT         6
#define U61_EVENT_ROTATE_LEFT        7
#define U61_EVENT_ROTATE_RIGHT       8
#define U61_EVENT_MOVE_DOWN          9
#define U61_EVENT_DROP              10
#define U61_EVENT_SET_VICTIM        11
#define U61_EVENT_NEXT_VICTIM       12
#define U61_EVENT_PREV_VICTIM       13
#define U61_EVENT_USE_ANTIDOTE      14
 
#define U61_EVENT_NEW_BLOCK         15
#define U61_EVENT_LOOSE             16
#define U61_EVENT_NEW_CURSE         17
#define U61_EVENT_REQUEST_CURSE     18
#define U61_EVENT_DO_CURSE          19

#define U61_EVENT_HISTORY_BEGIN     20
#define U61_EVENT_HISTORY_END       21

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Event
{ 
 public:
  U61_Event();
  ~U61_Event();
 
  unsigned int code : 8;
  unsigned int author : 4;
  unsigned int target : 4;
  unsigned int par : 16;
  unsigned int time : 32;

  void serialize(unsigned char *buffer);
  void unserialize(unsigned char *buffer);
  
 protected:  
};

ostream &operator <<(ostream &o, U61_Event evt);

#endif
