/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   filtercopy.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a filter copy sends the events to a dispatcher,
 *              which is responsible for queuing events before sending
 *              them, send them to the right player...
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "filtercopy.h"
#include "time.h"
#include "debug.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a filter event copy
 */ 
U61_FilterCopy::U61_FilterCopy(int player_id,U61_Dispatcher *d)
  :U61_EventCopy(player_id)
{
  dispatcher=d;
}

/*--------------------------------------------------------------------------*/
/*
 * flushes all the events, ie sends them to the dispatcher
 */
void U61_FilterCopy::flush()
{
  U61_Event event;

  while (!queue.empty())
    {
      event=queue.front();
      queue.pop_front();

      if (filter(event))
	{
          U61_LOG_DEBUG("Putting event "<<event<<" in dispatcher");
	  dispatcher->put_out(event);
	}
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Filters an event by returning true if the event is to be kept
 */
bool U61_FilterCopy::filter(U61_Event event)
{
  bool result=true;

  return result;
}
