/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   history.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: This is a small utility class to keep a track of what
 *              happened to each player since its last game session started.
 *              This is usefull in a network game for the server to be able
 *              to send to the new clients a complete history of what
 *              happened to each player.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "history.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a history item
 */ 
U61_History::U61_History()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/* 
 * resets all the history values
 */ 
void U61_History::reset()
{
  clear();
  state=false;
}

/*--------------------------------------------------------------------------*/
/* 
 * empties the history
 */ 
void U61_History::clear()
{
  events.clear();
}

/*--------------------------------------------------------------------------*/
/*
 * puts an event in the history queue
 */
void U61_History::put(U61_Event evt)
{
  switch(evt.code)
    {
    case U61_EVENT_LOOSE:
      loose(&evt);
      break;
    case U61_EVENT_START_STOP:
      start_stop();
      break;
    case U61_EVENT_KILL:
      kill();
      break;
    }

  events.push_back(evt);
}

/*--------------------------------------------------------------------------*/
/*
 * returns the history size
 */
int U61_History::size()
{
  return events.size();
}

/*--------------------------------------------------------------------------*/
/*
 * Returns a given event in the history
 * 0 should be the oldest event (ie the first one) and size-1 the last one
 */
U61_Event U61_History::get(int i)
{
  return events[i];
}

/*--------------------------------------------------------------------------*/
/*
 * To be called each time a loose event is detected
 */
void U61_History::loose(U61_Event *evt)
{
  clear();
  state=true;
  evt->code=U61_EVENT_START_STOP;
}

/*--------------------------------------------------------------------------*/
/*
 * To be called each time a start_stop event is detected
 */
void U61_History::start_stop()
{
  clear();
  state=!state;
}

/*--------------------------------------------------------------------------*/
/*
 * To be called each time a kill event is detected
 */
void U61_History::kill()
{
  clear();
  state=false;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns true if the player associated to this id is/should be playing
 */
bool U61_History::playing()
{
  return state;
}
