/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   music.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to start and stop playing music, one just has to ask
 *              for music number 'n' to be played and it starts playing
 *              and does automatically internal checks such as "does this
 *              music index exists in my current datafile"
 */


#ifndef INC_U61_MUSIC
#define INC_U61_MUSIC

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>
#include <ClanLib/sound.h>

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_MUSIC_VOLUME_MAX 10

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Music
{
 public:
  static void start();
  static void stop();
  static void update();
  static void pause();
  static void resume();

  static void set_change_limit(int limit=1);
  static void change(bool force=false);

 protected:
  static CL_SoundBuffer_Session *session;
  static int change_counter;
  static int last_chosen;
  static int change_limit;
};

#endif
