/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   savescriptmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: prompts the user with a menu which asks him if he,
 *              wants to save the script on his local hard drive.
 *              This is usefull if one wants to share scripts with
 *              friends.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "savescriptmenu.h"
#include "button.h"
#include "edit.h"
#include "global.h"
#include "platform.h"
#include "debug.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the confirmation menu
 */ 
U61_SaveScriptMenu::U61_SaveScriptMenu(U61_Menu *parent) 
  : U61_Menu(parent,"Saving remote script")
{
  U61_Global::remote_script.reset();

  add_item(new U61_Button("Do not save the script"));
  add_item(new U61_Button("Save the script"));
  add_item(new U61_Edit("Name",U61_Global::remote_script.name_buffer));

  select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_SaveScriptMenu::validate()
{
  U61_Menu *next_menu;

  next_menu=this;
  switch (selection)
    {
    case 0:
      next_menu=back();
      break;
    case 1:
      if (save())
	{
	  next_menu=back();
        }
      break;
    }

  return next_menu;
}

/*--------------------------------------------------------------------------*/
/*
 * Tries to save the remote script on the local hard drive
 */
bool U61_SaveScriptMenu::save()
{
  bool ok=false;
  char buffer[U61_CONST_STRING_SIZE];
  FILE *f;
  
  U61_Global::data.chdir_to_initial_dir();
  
  strncpy(buffer,U61_Global::remote_script.name_buffer,sizeof(buffer)-1);
  U61_Platform::unstrip_remote_script_path(buffer);

  U61_LOG_MESSAGE("Saving script to \""<<buffer<<"\".");

  f=fopen(buffer,"w");
  if (f!=NULL)
    {
      fwrite(U61_Global::remote_script.code_buffer,
             strlen(U61_Global::remote_script.code_buffer),
             1,
             f);
      fclose(f);
      ok=true;
    }
  
  U61_Global::data.chdir_to_data_dir();

  return ok;
}

