/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   script.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: wraps the LUA api to C++ and vice-versa
 *              all the interaction with lua is contained in this file
 *              it might be splited some day since it's getting *big*
 *              lua scripting is fundamental in u61. in fact all the
 *              rules of the game are coded in lua. this allows a 
 *              player/hacker  to write his own rules and test them
 *              right away without recompiling, and be quite
 *              "protection fault" safe
 */


#ifndef INC_U61_SCRIPT
#define INC_U61_SCRIPT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "block.h"
#include "map.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Script
{
 public:
  static void open();
  static void close();

  static bool do_string(char *str);
  static bool do_file(char *file);
  static int get_global_int(char *name,int def=0);
  static bool get_global_bool(char *name,bool def=false);
  static char *get_global_str(char *name,char *def="");

  static bool init();
  static void collect_garbage();

  static bool check_id();

  static char *get_program();
  static char *get_version();
  static int new_shape(U61_Map *m,U61_Block *b);
  static void do_shape(U61_Map *m,U61_Block *b,int type);
  static void rotate_left(U61_Map *m,U61_Block *b);
  static void rotate_right(U61_Map *m,U61_Block *b);
  static void move_left(U61_Map *m,U61_Block *b);
  static void move_right(U61_Map *m,U61_Block *b);
  static void move_down(U61_Map *m,U61_Block *b);
  static void land(U61_Map *m,U61_Block *b);
  static bool match_pattern(U61_Map *m);
  static void time_callback_1(U61_Map *m,U61_Block *b);
  static void time_callback_10(U61_Map *m,U61_Block *b);
  static void time_callback_100(U61_Map *m,U61_Block *b);
  static void square_blown_up(U61_Map *m,int x,int y);
  static int new_curse(U61_Map *m,U61_Block *b);
  static void do_curse(U61_Map *m,U61_Block *b,int id,bool sent);
  static void use_antidote(U61_Map *m,U61_Block *b);
  static char *get_curse_name(U61_Map *m,int id);


 protected:
  static void secure_pointers();
  static void record_all();
};

#endif
