#!/bin/sh
#
# This script has been ripped from the Allegro game library.
# It handles the CR/LF in the text files so that there are
# no conflicts between DOS/Windows and UNIX text readers.

proc_help()
{
   echo "Usage: ./fix.sh {unix|dos}"
   exit 1
}

proc_fix_unix()
{
   proc_filelist
   FILELIST="$FILELIST `find . -type f "(" \
   	-name "*.sh" -o \
        -name "*.in" \
	")"`" 
   proc_dtou
   proc_chmod
}

proc_fix_dos()
{
   proc_filelist
   proc_utod
}

proc_filelist()
{
   # common files.
   FILELIST=`find . -type f "(" \
      -name "*.cpp" -o \
      -name "*.h" -o \
      -name "*.txt" -o \
      -name "*.html" -o \
      -name "*.lua" -o \
      -name "Makefile.*" -o \
      -name "AUTHORS" -o \
      -name "CHANGES" -o \
      -name "COPYING" -o \
      -name "DATAFILE" -o \
      -name "DOCUMENTATION" -o \
      -name "INSTALL" -o \
      -name "INSTALL.linux" -o \
      -name "INSTALL.windows" -o \
      -name "README" -o \
      -name "TODO" -o \
      -name "ChangeLog" \
   ")"`
}

proc_chmod()
{
   echo "Changing file attributes..."
   find . -type d | xargs chmod 755
   find . -type f | xargs chmod 644
   find . -type f "(" \
   	-name "configure" -o \
	-name "config.status" -o \
	-name "package.sh" -o \
	-name "fix.sh" -o \
	-name "u61" \
   ")" | xargs chmod 755
}

proc_utod()
{
   echo "Converting files from Unix to DOS/Win32..."
   for file in $FILELIST; do
      #echo "$file"
      cp $file _tmpfile
      perl -p -i -e "s/([^\r]|^)\n/\1\r\n/" _tmpfile
      touch -r $file _tmpfile
      mv _tmpfile $file
   done
}

proc_dtou()
{
   echo "Converting files from DOS/Win32 to Unix..."
   for file in $FILELIST; do
      #echo "$file"
      mv $file _tmpfile
      tr -d '\015' < _tmpfile > $file
      touch -r _tmpfile $file
      rm _tmpfile
   done
}

# prepare allegro for the given platform.

case "$1" in
   "unix"    ) proc_fix_unix;;
   "dos"     ) proc_fix_dos;;
   *         ) proc_help;;
esac

exit 0

