/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   aboutmenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the about menu tells the end-user what U61 is
 *              and explains its free software status
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "aboutmenu.h"
#include "text.h"
#include "const.h"
#include "version.h"

#include <stdio.h>

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the empty menu
 */ 
U61_AboutMenu::U61_AboutMenu(U61_Menu *parent) 
    : U61_Menu(parent,"U61 by U-Foot")
{
    char buf1[U61_CONST_STRING_SIZE];
    char buf2[U61_CONST_STRING_SIZE];

    U61_Version::get_version_text(buf1);
    sprintf(buf2,"Release %s",buf1);

    add_item(new U61_Text(buf2));
    add_item(new U61_Text(" "));
    add_item(new U61_Text("Copyright (C) 2000-2002"));
    add_item(new U61_Text(" "));
    add_item(new U61_Text("Author: Christian Mauduit"));
    add_item(new U61_Text("License: free software (GPL)"));
    add_item(new U61_Text("Home: www.ufoot.org/u61"));
    add_item(new U61_Text("Contact: ufoot@ufoot.org"));
    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * this function does nothing, this way the player sees plain text
 */
void U61_AboutMenu::select_up()
{
    
}

/*--------------------------------------------------------------------------*/
/*
 * this function does nothing, this way the player sees plain text
 */
void U61_AboutMenu::select_down()
{
    
}

