/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   debug.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utilities to log messages and debug the program
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "debug.h"
#include "platform.h"
#include "const.h"
#include "global.h"
#include "version.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * This console is used for output under windows
 */
CL_ConsoleWindow *U61_Debug::console;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Initializes the debug system
 */
void U61_Debug::init()
{
  char buf[U61_CONST_STRING_SIZE];        
  char console_name[U61_CONST_STRING_SIZE];        
    
  U61_Version::get_version_text(buf);
  sprintf(console_name,
	  "U61 %s log window",
	  buf);

  console=new CL_ConsoleWindow(console_name);
  if (console!=NULL)
    {
      console->redirect_stdio();
    }

  U61_Global::data.chdir_to_initial_dir();
  U61_Platform::open_log_files();
  U61_Global::data.chdir_to_data_dir();
}

/*--------------------------------------------------------------------------*/
/*
 * De-initializes the debug system
 */
void U61_Debug::deinit()
{
  U61_Platform::close_log_files();

  if (console!=NULL)
    {
      //console->display_close_message();
      delete console;
      console=NULL;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Writes stuff to the log files
 */
void U61_Debug::flush()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Displays a "press <ENTER> to close message under windows
 */
void U61_Debug::display_close_message()
{
  if (console)
    {
      console->display_close_message();
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Called within the U61_LOG_ERROR macro
 */
void U61_Debug::log_error(ostrstream &s)
{
  char buffer[U61_CONST_STRING_SIZE];
  int len;

#ifndef U61_MSVC
  s.freeze(U61_CONST_STRING_SIZE);
#endif
  len=s.pcount();
  if (len>(int) sizeof(buffer)-1)
    {
      len=sizeof(buffer)-1;
    }
  strncpy(buffer,s.str(),len);
#ifndef U61_MSVC
  s.freeze(0);
#endif

  buffer[len]=0;
  std::cerr<<"u61: ERROR! "<<buffer<<"\n";
  U61_Platform::log_to_error_file(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * Called within the U61_LOG_WARNING macro
 */
void U61_Debug::log_warning(ostrstream &s)
{
  char buffer[U61_CONST_STRING_SIZE];
  int len;

#ifndef U61_MSVC
  s.freeze(U61_CONST_STRING_SIZE);
#endif
  len=s.pcount();
  if (len>(int) sizeof(buffer)-1)
    {
      len=sizeof(buffer)-1;
    }
  strncpy(buffer,s.str(),len);
#ifndef U61_MSVC
  s.freeze(0);
#endif

  buffer[len]=0;
  std::cerr<<"u61: WARNING! "<<buffer<<"\n";
  U61_Platform::log_to_warning_file(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * Called within the U61_LOG_MESSAGE macro
 */
void U61_Debug::log_message(ostrstream &s)
{
  char buffer[U61_CONST_STRING_SIZE];
  int len;

#ifndef U61_MSVC
  s.freeze(U61_CONST_STRING_SIZE);
#endif
  len=s.pcount();
  if (len>(int) sizeof(buffer)-1)
    {
      len=sizeof(buffer)-1;
    }
  strncpy(buffer,s.str(),len);
#ifndef U61_MSVC
  s.freeze(0);
#endif

  buffer[len]=0;
  std::cout<<"u61: "<<buffer<<"\n";
  U61_Platform::log_to_message_file(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * Called within the U61_LOG_DEBUG macro
 */
void U61_Debug::log_debug(ostrstream &s,char *file,int line)
{
  char buffer[U61_CONST_STRING_SIZE];
  int len;

#ifndef U61_MSVC
  s.freeze(U61_CONST_STRING_SIZE);
#endif
  len=s.pcount();
  if (len>(int) sizeof(buffer)-1)
    {
      len=sizeof(buffer)-1;
    }
  strncpy(buffer,s.str(),len);
#ifndef U61_MSVC
  s.freeze(0);
#endif

  buffer[len]=0;
  //std::cout<<"U61 debug: "<<buffer<<" (from "<<file<<":"<<line<<")\n";
  U61_Platform::log_to_debug_file(buffer,file,line);
}

