/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   debug.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utilities to log messages and debug the program
 */

#ifndef INC_U61_DEBUG
#define INC_U61_DEBUG

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

/*
 * Win32 is just a poor OS which handles long names like s..t, so we have to
 * use #defines to include strstrea.h instead of strstream.h 8-(
 */
#ifdef U61_MSVC
#include <strstream>
#else
#include <strstream.h>
#endif

//#include <fstream>

#include <ClanLib/core.h>

/*---------------------------------------------------------------------------
 macros
 ---------------------------------------------------------------------------*/

#define U61_LOG_ERROR(M) {ostrstream s;s<<__FILE__<<":"<<__LINE__<<" "<<M;U61_Debug::log_error(s);}
#define U61_LOG_WARNING(M) {ostrstream s;s<<M;U61_Debug::log_warning(s);}
#define U61_LOG_MESSAGE(M) {ostrstream s;s<<M;U61_Debug::log_message(s);}
#ifdef DEBUG
#define U61_LOG_DEBUG(M) {ostrstream s;s<<__FILE__<<":"<<__LINE__<<" "<<M;U61_Debug::log_debug(s,__FILE__,__LINE__);}
#else
#define U61_LOG_DEBUG(M)
#endif

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Debug
{
public:
    static void init();
    static void deinit();
    static void flush();    

    static void display_close_message();

    static void log_error(ostrstream &s);
    static void log_warning(ostrstream &s);
    static void log_message(ostrstream &s);
    static void log_debug(ostrstream &s,char *file,int line);
protected:
    static CL_ConsoleWindow *console;
};

#endif



