/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   editaddress.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a menu item which allows the user to edit addresses
 *              such as the server IP and/or hostna;e for instance
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "editaddress.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of an 'address' item
 */ 
U61_EditAddress::U61_EditAddress(char *label, char *val) : U61_Edit(label,val)
{

}

/*--------------------------------------------------------------------------*/
/*
 * Translates a key code into an ascii code.
 * This operation is very important for this item, for here we need
 * to be 100% sure the user can type a ".". "-" is also usefull, but
 * not as much as '.'. Basically, if digits and "." work, we can enter
 * an IP address so it's at least possible to to something.
 */
int U61_EditAddress::translate_to_ascii(int key)
{
  int ascii;

  ascii=U61_Global::input_monitor.to_ascii(key);
  
  if (!isalnum(ascii) &&
      ascii!='-')
    {
      ascii='.';
    }

  return ascii;
}











