/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   keychoose.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: a menu item which allows the user to choose
 *              a key. usefull for player settings
 */



/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>

#include "const.h"
#include "keychoose.h"
#include "menuinput.h"
#include "debug.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * a global pointeur which points on the menuinput used to retrieve keys
 */
U61_MenuInput *U61_KeyChoose::key_map=NULL;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'keychoose' item
 */ 
U61_KeyChoose::U61_KeyChoose(char *label, int *val) : U61_MenuItem()
{
  name=label;
  value=val;
  waiting=false;
  update();
}

/*--------------------------------------------------------------------------*/
/*
 * updates the text displayed so that it reflects the value of the item
 */
void U61_KeyChoose::update()
{
  char buffer[U61_CONST_STRING_SIZE];

  strcpy(buffer,name);
  strcat(buffer,U61_MENUITEM_SEPARATOR);
  if (waiting)
    {
      strcat(buffer,"press a key");
    }
  else
    {
      strcat(buffer,U61_Global::input_monitor.to_label(*value));
    }
  set_text(buffer);
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_KeyChoose::action(int key)
{
  bool changed=false;

  if (waiting)
    {
      (*value)=key;
      waiting=false;
      changed=true;
    }
  else
    {
      switch (key)
        {
        case CL_KEY_ENTER:
        case CL_KEY_RIGHT:
        case CL_KEY_LEFT:
	  waiting=true;
	  changed=true;
	  break;
        }
    }

  return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * selection of the item (only selects the key value)
 */
void U61_KeyChoose::select()
{
  int start;

  start=strlen(name)+strlen(U61_MENUITEM_SEPARATOR);

  select_right(start);
}

/*--------------------------------------------------------------------------*/
/*
 * returns true is the item is in waiting mde, therefore modal
 */
bool U61_KeyChoose::is_modal()
{
  return waiting;
}

/*--------------------------------------------------------------------------*/
/*
 * registers a key map. the MenuInput object will be used to get scancodes
 * from ascii codes
 */
void U61_KeyChoose::register_key_map(U61_MenuInput *km)
{
  key_map=km;
}
