/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   systeminfo.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: used to calculate and display system information such
 *              as the number of frames per sec for instance
 */

#ifndef INC_U61_SYSTEMINFO
#define INC_U61_SYSTEMINFO

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "time.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_SystemInfo
{
 public:
  U61_SystemInfo();

  void register_idle();
  void register_logic();
  void register_display();
  void register_bytes_in(int bytes);
  void register_bytes_out(int bytes);

  float get_idle_rate();
  int get_logic_per_sec();
  int get_display_per_sec();
  int get_bytes_in_per_sec();
  int get_bytes_out_per_sec();

  void draw();

 protected:
  void reset_if_needed();

  unsigned int start_time;

  int idle_count;
  int logic_count;
  int display_count;
  int bytes_in_count;
  int bytes_out_count;

  float last_idle_rate;
  int last_logic_per_sec;
  int last_display_per_sec;
  int last_bytes_in_per_sec;
  int last_bytes_out_per_sec;
};

#endif
