/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000 Christian Mauduit (ufoot@ufoot.org / www.ufoot.org)   *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on SourceForge  (http://sourceforge.net)  *
 ****************************************************************************/

/*
 * file name:   version.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: tools for game versionning, useful in a network game
 *              to tell which version of the game people have...
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "version.h"

#include <ctype.h>
#include <string.h>

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*
 * We store the version here
 */
char *U61_Version::version=U61_VERSION;

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * writes a string containing the version into a buffer (example "0.1.3")
 */
void U61_Version::get_version_text(char *buffer)
{
    strcpy(buffer,version);
}

/*--------------------------------------------------------------------------*/
/*
 * returns a number identifying the version in a unique manner
 */
int U61_Version::get_version_code()
{
  int result=10;
  char *pos;
  int digit;

  pos=version;
  while (*pos)
    {
      if (isalnum(*pos))
	{
	  result*=100;
	  digit=(*pos)-32;
	  digit = (digit<0) ? 0 : digit;
	  digit = (digit>99) ? 99 : digit;
	  result+=digit;
	}
    }
  
  return result;
}


