/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   activeplayermenu.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: With this menu one chooses who will be playing on the
 *              local machine. The settings are the same for local or
 *              a network game. If no players are selected, player 1
 *              is assumed to be playing.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "activeplayermenu.h"
#include "toggle.h"
#include "global.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of the active player menu
 */ 
U61_ActivePlayerMenu::U61_ActivePlayerMenu(U61_Menu *parent)
    : U61_Menu(parent,"Now who's playing?")
{
    add_item(new U61_Toggle("Player 1 is",
        &(U61_Global::config.player[0].activable),"playing","disabled"));
    add_item(new U61_Toggle("Player 2 is",
        &(U61_Global::config.player[1].activable),"playing","disabled"));
    add_item(new U61_Toggle("Player 3 is",
        &(U61_Global::config.player[2].activable),"playing","disabled"));
    add_item(new U61_Toggle("Player 4 is",
        &(U61_Global::config.player[3].activable),"playing","disabled"));

    select(0);
}

/*--------------------------------------------------------------------------*/
/*
 * validate is called when the user presses enter
 */
U61_Menu *U61_ActivePlayerMenu::validate()
{
    U61_Menu *next_menu;

    next_menu=this;

    return next_menu;
}
