/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   bufferedsocket.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: subclass of socket which allow buffer sends/reads
 *              in a "buffered" context. Sends and receives never
 *              fail unless the socket is really closed. If send/receives
 *              are successfull, then 100% of the requested date is
 *              sent/received successfully.
 */


#ifndef U61_INC_BUFFEREDSOCKET
#define U61_INC_BUFFEREDSOCKET

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "socket.h"
#include "socketbuffer.h"

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_BufferedSocket : public U61_Socket
{
public:
  U61_BufferedSocket();
  ~U61_BufferedSocket();

  U61_BufferedSocket *accept();

  bool push_buf(char *buf, int size);
  bool pop_buf(char *buf, int size, bool peek);

  int get_input_size();
  bool flush_if_needed();

  bool flush_output();
  bool flush_input();

  bool flush_input_needed();
  bool flush_output_needed();

protected:
  U61_BufferedSocket(U61_Socket *s);

  U61_SocketBuffer input_buffer;
  U61_SocketBuffer output_buffer;

  unsigned int last_flush_input_time;
  unsigned int last_flush_output_time;
};

#endif
