/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   chatdisplayline.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: holds information for a chat line, and provides methods
 *              to display it.
 */

#ifndef U61_INC_CHATDISPLAYLINE
#define U61_INC_CHATDISPLAYLINE

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "event.h"
#include "textdisplayer.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_CHATDISPLAYLINE_MAX_LENGTH 200

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ChatDisplayLine
{
 public:
  U61_ChatDisplayLine();
  ~U61_ChatDisplayLine();

  void reset();
  void put_chat_letter(U61_Event evt);
  bool full();
  bool empty();
  int get_player_id();
  void set_player_id(int pid);
  char *get_player_name();
  unsigned int get_last_update();

  void draw(int x, 
	    int y,
	    int w=U61_TEXTDISPLAYER_MAX_W, 
	    int h=U61_TEXTDISPLAYER_MAX_H,
	    bool cursor=false);
  int get_height(int w=U61_TEXTDISPLAYER_MAX_W,
		 bool cursor=false);

 protected:
  int player_id;
  bool end_forced;
  char text[U61_CHATDISPLAYLINE_MAX_LENGTH+1];
  unsigned int last_update;

  void log_text();
  U61_TextDisplayer *prepare_draw(bool cursor);
};

#endif
