/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   chatinput.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: special input class dedicated to transforming keyboard
 *              strokes into chat letter events.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "chatinput.h"

/*--------------------------------------------------------------------------*/
/*
 * Constructor of the chatinput class
 */
U61_ChatInput::U61_ChatInput()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * Destructor of the chatinput class
 */
U61_ChatInput::~U61_ChatInput()
{

}

/*--------------------------------------------------------------------------*/
/*
 * Resets all the items of a chatinput
 */
void U61_ChatInput::reset()
{
  toggleable=false;
  set_active(false);
}

/*--------------------------------------------------------------------------*/
/*
 * This function needs to be called on a regular basis.
 */
void U61_ChatInput::poll(unsigned int time)
{
  if (is_active())
    {
      /*
       * We do not poll if it's not active, this avoids useless hudge
       * unused queues.
       */
      U61_Input::poll(time);
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Resets all the items of a chatinput
 */
bool U61_ChatInput::is_active()
{
  return active;
}

/*--------------------------------------------------------------------------*/
/*
 * Resets all the items of a chatinput
 */
void U61_ChatInput::set_active(bool a)
{
  /*
   * We reset the input object since each we turn chatinput on/off we want
   * to clear the key buffer.
   */
  U61_Input::reset();

  active = a ? true : false;
  if (active)
    {
      toggleable=true;
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Resets all the items of a chatinput
 */
void U61_ChatInput::toggle()
{
  /*
   * The "toggleable" trick is just so that pressing F4 won't turn
   * chat on when not playing, or when one is playing in local mode.
   */
  if (toggleable)
    {
      set_active(!is_active());
    }
}

/*--------------------------------------------------------------------------*/
/*
 * Returns true if there's no CHAT_LETTER event pending
 */
bool U61_ChatInput::empty()
{
  bool e=true;

  if (is_active())
    {
      e=U61_Input::empty();
    }

  return e;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the next CHAT_LETTER event pending
 */
U61_Event U61_ChatInput::get()
{
  U61_Event evt;

  evt=U61_Input::get();

  /*
   * Here we change the fields of the event.
   */
  evt.par=evt.code;
  evt.code=U61_EVENT_CHAT_LETTER;

  /*
   * the author field will be filled afterwards
   */

  return evt;
}



