/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   chatinput.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: special input class dedicated to transforming keyboard
 *              strokes into chat letter events.
 */

#ifndef U61_INC_CHATINPUT
#define U61_INC_CHATINPUT

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "completeinput.h"
#include "event.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_ChatInput : public U61_CompleteInput
{
 public:
  U61_ChatInput();
  ~U61_ChatInput();

  virtual void reset();

  virtual void poll(unsigned int time);
  bool is_active();
  void set_active(bool a=true);
  void toggle();

  virtual bool empty();
  virtual U61_Event get();

  /*
   * We need to make this public since it's used in a toggle object...
   */
  bool active;
  bool toggleable;

 protected:

};

#endif
