/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   checksum.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utility functions to calculate checksums. It's a simple
 *              wrapper over MD5 functions.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "checksum.h"
#include "log.h"
#include "macro.h"
#include "serial.h"
#include "utils.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Creates a checksum object
 */
U61_Checksum::U61_Checksum()
{
  calc_init();
}

/*--------------------------------------------------------------------------*/
/*
 * Destroys a checksum object
 */
U61_Checksum::~U61_Checksum()
{
}

/*--------------------------------------------------------------------------*/
/*
 * Initializes the checksum object
 */
void U61_Checksum::calc_init()
{
  U61_MACRO_MEMSET0(binary_sig);
  U61_MACRO_MEMSET0(ascii_sig);
  MD5Init(&md5c);
}

/*--------------------------------------------------------------------------*/
/*
 * Calculates the checksum for a given chunck of data. No pre/post init.
 */
void U61_Checksum::calc_update(char *buffer, int size)
{
  MD5Update(&md5c, (unsigned char *) buffer, size);
}

/*--------------------------------------------------------------------------*/
/*
 * Final operation of the calculus
 */
void U61_Checksum::calc_final()
{
  MD5Final((unsigned char *) binary_sig,&md5c);

  U61_Utils::to_hexascii(ascii_sig,(unsigned char *) binary_sig,U61_CHECKSUM_BINARY_SIZE);
}
  
/*--------------------------------------------------------------------------*/
/*
 * Calculates the checksum for a given chunck of data. All in one func.
 */
void U61_Checksum::calc(char *buffer, int size)
{
  calc_init();
  calc_update(buffer,size);
  calc_final();
}
  
/*--------------------------------------------------------------------------*/
/*
 * Returns the binary signature.
 */
char *U61_Checksum::get_binary_sig()
{
  return binary_sig;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns the signature as a 0 terminated readable string.
 */
char *U61_Checksum::get_ascii_sig()
{
  return ascii_sig;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns a partial signature as a short, this is for in-game map checksums.
 */
short U61_Checksum::get_short_sig()
{
  short sig;
  unsigned char *buf;

  buf=(unsigned char *) binary_sig;
  U61_Serial::unserialize_short(&sig,&buf,buf+sizeof(short));

  return sig;
}
