/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   completeinput.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: input subclass which creates an input object which handles
 *              all the keys available on the keyboard and handled by
 *              ClanLib.
 */

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "completeinput.h"
#include "inputmonitor.h"
#include "time.h"
#include "log.h"
#include "global.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_COMPLETEINPUT_REPEAT_FIRST      50
#define U61_COMPLETEINPUT_REPEAT_STANDARD   15

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a complete input object
 */ 
U61_CompleteInput::U61_CompleteInput() : U61_Input(U61_INPUTMONITOR_NUM_KEYS)
{
  init();
}

/*--------------------------------------------------------------------------*/
/* 
 * destruction of a complete input object
 */ 
U61_CompleteInput::~U61_CompleteInput()
{
}

/*--------------------------------------------------------------------------*/
/*
 * initializations of the complete keys
 */
void U61_CompleteInput::init()
{
  int i;
  U61_Key key;

  for (i=0;i<U61_INPUTMONITOR_NUM_KEYS;++i)
    {
      key.init(i,i,U61_COMPLETEINPUT_REPEAT_FIRST,U61_COMPLETEINPUT_REPEAT_STANDARD);
      set_key(i,key);
    } 
}


