/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   connection.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the connection object is a low-level wrapper over
 *              ClanLib's network API, it's the equivalent of a socket
 */


#ifndef U61_INC_CONNECTION
#define U61_INC_CONNECTION

/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "packet.h"
#include "event.h"
#include "bufferedsocket.h"
#include "dispatcher.h"

/*---------------------------------------------------------------------------
  classes
  ---------------------------------------------------------------------------*/

class U61_Connection
{
 public:
  U61_Connection(U61_BufferedSocket *s);
  ~U61_Connection();

  bool send(U61_Packet *p);
  bool send(char *str,int max);
  bool send(int i);
  bool send(U61_Event evt);

  bool recv(U61_Packet *p);
  bool recv(char *str,int max);
  bool recv(int *i);
  bool recv(U61_Event *evt);

  bool peek_packet();
  bool peek_str();
  bool peek_int();
  bool peek_event();

  void authorize_all();
  void authorize_none();
  void authorize_player_id(int player_id, bool state);
  bool is_authorized(int player_id);
  bool is_alive();

  void close();

 protected:
  U61_BufferedSocket *sock;
  bool opened;
  bool authorized_player_id[U61_DISPATCHER_MAX_PLAYER_ID];
};

#endif
