/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   dispatcher.h
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: the dispatcher is responsible for sending & receiving
 *              messages from the network, and send them to the right person
 *              it's the main "complex" interface with the low level
 *              network API
 */


#ifndef U61_INC_DISPATCHER
#define U61_INC_DISPATCHER

/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <ClanLib/core.h>

#include "dispatcheritem.h"

/*---------------------------------------------------------------------------
 constants
 ---------------------------------------------------------------------------*/

#define U61_DISPATCHER_MAX_PLAYER_ID 16

/*---------------------------------------------------------------------------
 classes
 ---------------------------------------------------------------------------*/

class U61_Dispatcher
{
public:
    U61_Dispatcher();
    virtual ~U61_Dispatcher();

    virtual void reset();

    bool empty_in(int player_id);
    void put_out(U61_Event event);
    U61_Event get_in(int player_id);        

    bool process();

    virtual bool send(U61_Event evt);
    virtual bool recv(U61_Event *evt);
    virtual bool peek();

    bool is_player_busy(int player_id);

 protected:
    bool empty_out();
    U61_Event get_out();
    void put_in(U61_Event event,int player_id);
    void look(U61_Event evt);
    void check_ready_all(U61_Event evt);

    std::list<U61_Event> outgoing_queue;  
    U61_DispatcherItem items[U61_DISPATCHER_MAX_PLAYER_ID];

    bool ready_all_flag;
};

#endif
