/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   dispatcheritem.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: utility class used to hold data for the main dispatcher
 *              class.
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "dispatcheritem.h"
#include "time.h"
#include "log.h"

/*---------------------------------------------------------------------------
 variants
 ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * creates a dispatcher
 */
U61_DispatcherItem::U61_DispatcherItem()
{
  reset();
}

/*--------------------------------------------------------------------------*/
/*
 * deletes a dispatcher
 */
U61_DispatcherItem::~U61_DispatcherItem()
{
}

/*--------------------------------------------------------------------------*/
/*
 * Empties all the queues
 */
void U61_DispatcherItem::reset()
{
  incoming_queue.clear();
  ready_flag=false;
  busy_flag=false;
}

/*--------------------------------------------------------------------------*/
/*
 * Returns true if there are no more incoming events for a given player
 */
bool U61_DispatcherItem::empty_in()
{
  return incoming_queue.empty();
}

/*--------------------------------------------------------------------------*/
/*
 * Gets an event for a given player
 */
U61_Event U61_DispatcherItem::get_in()
{
  U61_Event event;

  event=incoming_queue.front();
  incoming_queue.pop_front();

  return event;
}

/*--------------------------------------------------------------------------*/
/*
 * Puts an event in the incoming queue
 */
void U61_DispatcherItem::put_in(U61_Event event)
{
  incoming_queue.push_back(event);
}

/*--------------------------------------------------------------------------*/
/*
 * Gets the "busy" parameter
 */
bool U61_DispatcherItem::get_busy()
{
  return busy_flag;
}

/*--------------------------------------------------------------------------*/
/*
 * Gets the "ready" parameter
 */
bool U61_DispatcherItem::get_ready()
{
  return ready_flag;
}

/*--------------------------------------------------------------------------*/
/*
 * Sets the "busy" parameter
 */
void U61_DispatcherItem::set_busy(bool b)
{
  busy_flag=b;
}

/*--------------------------------------------------------------------------*/
/*
 * Sets the "ready" parameter
 */
void U61_DispatcherItem::set_ready(bool b)
{
  ready_flag=b;
}


