/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   dns.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: DNS utilities
 */


/*---------------------------------------------------------------------------
  includes
  ---------------------------------------------------------------------------*/

#include <string.h>

#ifdef U61_DEF_WIN32
#include <winsock.h>
#include "socketwindows.h"
#endif
#ifdef U61_DEF_UNIX
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include "dns.h"
#include "log.h"
#include "macro.h"
#include "const.h"

/*---------------------------------------------------------------------------
  variants
  ---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
  functions
  ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/*
 * Returns true if the string is an IP address
 */
bool U61_Dns::is_ip(char *host)
{
  bool result;
  struct in_addr addr;

  result=inet_aton(host, &addr) ? true : false;

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * DNS request
 */
bool U61_Dns::get_ip_text(char ip[U61_CONST_STRING_SIZE], char *host)
{
  bool result=false;
  struct in_addr addr;
  int ip_int;

  memset(ip,0,U61_CONST_STRING_SIZE);
  if (get_ip_int(&ip_int,host))
    {
      addr.s_addr=ip_int;
      U61_MACRO_STRNCPY(ip,inet_ntoa(addr),U61_CONST_STRING_SIZE);
    }

  return result;
}

/*--------------------------------------------------------------------------*/
/*
 * DNS request
 */
bool U61_Dns::get_ip_int(int *ip, char *host)
{
  bool result = false;
  struct hostent *h;
  struct in_addr addr;

  *ip=0;
  h=gethostbyname(host);
  if (h && 
      h->h_addrtype==AF_INET && 
      h->h_length>=4 && 
      h->h_addr_list[0])
    {
#ifdef U61_DEF_UNIX
      addr = *((struct in_addr *) (h->h_addr_list[0]));
#else
      addr.s_addr = *((u_long *) (h->h_addr_list[0]));
#endif

      *ip=addr.s_addr;
      result=true;
    }

  if (!result)
    {
      U61_LOG_WARNING("Unable to resolve host \""<<host<<"\"");
    }

  return result;
}



















