/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   editnumber.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: A menu item which allows the user to type a number.
 *              this is different from the number item where the number
 *              is chosen with the arrow keys.
 *              Here, one just type the text as if it were a "edit" item
 */



/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "editnumber.h"
#include "menuinput.h"
#include "global.h"
#include "macro.h"
#include "log.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

#define U61_EDITNUMBER_BUFFER_SIZE 10
 
/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'number edit' item
 */ 
U61_EditNumber::U61_EditNumber(char *label, 
			       int *val, int min_val,int max_val) 
  : U61_Edit(label,NULL,U61_EDITNUMBER_BUFFER_SIZE)
{ 
  number_value=val;
  min_value=min_val;
  max_value=max_val;

  check_value();

  update();
}

/*--------------------------------------------------------------------------*/
/*
 * callback for key presses
 */
bool U61_EditNumber::action(int key)
{
  bool changed=false;
  int ascii;

  ascii=U61_Global::input_monitor.to_ascii(key);
  if (isdigit(ascii) || !isalnum(ascii))
    {
      changed=U61_Edit::action(key);
      *number_value=atoi(value);   
    } 

  return changed;
}

/*--------------------------------------------------------------------------*/
/*
 * Value check performed when the item is de-selected or deleted.
 * Think of it as a "lost focus" event.
 */
bool U61_EditNumber::check_value()
{
  char buf[U61_EDIT_MAX_SIZE+1];
  bool ok=true;

  ok = ok && U61_Edit::check_value();

  if (*number_value < min_value)
    {
      U61_LOG_DEBUG("edit number value too low ("<<*number_value<<")");
      *number_value = min_value;
    }
  if (*number_value > max_value)
    {
      U61_LOG_DEBUG("edit number value too high ("<<*number_value<<")");
      *number_value = max_value;
    }

  U61_MACRO_SPRINTF1(buf,"%d",*number_value);
  if (strcmp(buf,value)!=0)
    {
      ok=false;
      U61_MACRO_STRNCPY(value,buf,U61_EDITNUMBER_BUFFER_SIZE+1);
    }

  return ok;
}


