/****************************************************************************
 *                                                                          *
 * U U    6   1            U U   FFF  O   O  TTT                            *
 * U U   6   11   b        U U   F   O O O O  T                             *
 * U U - 66   1   bb  y y  U U - FF  O O O O  T                             *
 * U U   6 6  1   b b  y   U U   F   O O O O  T                             *
 *  U     6   1   bb   y    U    F    O   O   T                             *
 *                                                                          *
 * U61 is another block based game                                          *
 * Copyright (C) 2000-2003 Christian Mauduit (ufoot@ufoot.org)              *
 *                                                                          *
 * This program is free software; you can redistribute it and/or            *
 * modify it under the terms of the GNU General Public License              *
 * as published by the Free Software Foundation; either version 2           *
 * of the License, or (at your option) any later version.                   *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA*
 *                                                                          *
 * This project is also available on Savannah (http://savannah.gnu.org)     *
 ****************************************************************************/

/*
 * file name:   editport.cpp
 * author:      U-Foot (ufoot@ufoot.org / www.ufoot.org)
 * description: A menu item which allows the user to type a port.
 *              It's heavily based on the edit number widget, but one
 *              could imagine to implement in another manner...
 */


/*---------------------------------------------------------------------------
 includes
 ---------------------------------------------------------------------------*/

#include "editport.h"
#include "config.h"

/*---------------------------------------------------------------------------
 globals
 ---------------------------------------------------------------------------*/

#define U61_EDITPORT_MIN_PORT 1024
#define U61_EDITPORT_MAX_PORT 65535
 
/*---------------------------------------------------------------------------
 functions
 ---------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* 
 * creation of a 'number edit' item
 */ 
U61_EditPort::U61_EditPort(char *label, 
			   int *val)
  : U61_EditNumber(label,val,U61_EDITPORT_MIN_PORT,U61_EDITPORT_MAX_PORT)
{ 

}

/*--------------------------------------------------------------------------*/
/*
 * Value check performed when the item is de-selected or deleted.
 * Think of it as a "lost focus" event.
 */
bool U61_EditPort::check_value()
{
  bool ok=true;

  ok = ok && U61_EditNumber::check_value();

  if (!ok)
    {
      *number_value = U61_CONFIG_DEFAULT_PORT;
      U61_EditNumber::check_value();
    }

  return ok;
}
